/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   MODULO selor_passwd                                                           
   Programado por Lucas Priori                                                   
   Versao: 1.00                                                                  
                                                                                 
  Linux:                                                                         
  32 Bits: gcc -shared -nostartfiles selor_passwd.c -o selor_passwd.so -lcrypt -Wall
  64 Bits: gcc -shared -nostartfiles selor_passwd.c -o selor_passwd.so -lcrypt -DA64 -Wall -fPIC
                                                                                 
  FreeBSD:                                                                       
  32 Bits: gcc -shared -nostartfiles selor_passwd.c -o selor_passwd.so -lcrypt -DFreeBSD -Wall
  64 Bits: gcc -shared -nostartfiles selor_passwd.c -o selor_passwd.so -lcrypt -DFreeBSD -DA64 -Wall -fPIC
                                                                                 
  *****************************************************************************  
  Este programa  um modulo para acesso a usuarios do passwd do serv.            
  Copyright (C) 2013,2014  Lucas Priori                                          
                                                                                 
  This program is free software; you can redistribute it and/or                  
  modify it under the terms of the GNU General Public License                    
  as published by the Free Software Foundation; either version 2                 
  of the License, or (at your option) any later version.                         
                                                                                 
  This program is distributed in the hope that it will be useful,                
  but WITHOUT ANY WARRANTY; without even the implied warranty of                 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                  
  GNU General Public License for more details.                                   
                                                                                 
  You should have received a copy of the GNU General Public License              
  along with this program; if not, write to the Free Software                    
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#include<dirent.h>
#include<signal.h>
#include<pwd.h>
#include<sys/stat.h>
#ifdef FreeBSD
 #include<rpcsvc/crypt.h>
#else
 #include<crypt.h>
 #include<shadow.h>
#endif


#define MOD_NAME "pwd\0"
#define VERSAO "1.0\0"
#define TAM_buffer 2048
#define TAM_msg_error 200
#define TAM_cam_op 500
#define NUM_alias_regs 10
#define TAM_alias_regs 130
#define TAM_user 250
#define TAM_pass 250
#define TAM_home 500
#define TAM_dlocal 500
#define MOD_user_user 0
#define MOD_user_pass 1
#define MOD_user_home 2
#define MOD_user_dlocal 3
#define MOD_write [0][1]
#define MOD_read [1][0]
 




//---------------------------------------------------
//      Variaveis GLOBAIS                            
//---------------------------------------------------
FILE *arq_domains=NULL, *arq_alias=NULL, *arq_quota=NULL;
pid_t pid_pwdpipe=0;
struct spwd *sshadow;
struct passwd *pwd;
//struct str_alias{
// char email[TAM_alias_regs];
//}*alias=NULL;
char buffer[TAM_buffer + 1];
char linha[TAM_buffer + 1];
char msg_error[TAM_msg_error + 1];
// -- variaveis das opcoes --
char local_domains[TAM_cam_op + 1];
char alias_list[TAM_cam_op + 1];
char quota_list[TAM_cam_op + 1];
char mailbox_path[TAM_cam_op + 1];
char user_home[TAM_cam_op + 1];
char pwdpipe_mod[TAM_cam_op + 1];
char system_users=0;
char *mod_param[3]={"[selor_pwdpipe]", NULL, NULL};
int mod_pipe[2][2];
unsigned int tam_user=0;
unsigned int num_alias=0;
unsigned int atual_alias=0;
unsigned int max_alias_regs=NUM_alias_regs;
unsigned long long int default_quota=0;
// --- CACHE DE USUARIO ---
char cache_user[TAM_user]={0};
char cache_pass[TAM_pass]={0};
char cache_home[TAM_home]={0};
char cache_dlocal[TAM_dlocal]={0};
unsigned long long int cache_quota=0;


// =========================
//  Funcoes uteis do modulo 
// =========================

//---------------------------------------------------
// Funcao semelhante a strncpy, porem, retorna o     
// numero de bytes copiados, pra quando encontra    
// ZERO e tem                                        
// protecao contra buffer overflow                   
unsigned int local_strncpy(char *destino, char *origem, unsigned int tam_str){
 unsigned int ret_val;
 
 #ifdef A64
   asm(
   "mov  %0,%%rdi           \n"
   "mov  %1,%%rsi           \n"
   "mov  %%rsi,%%rbx        \n"
  "STRNCPY_prox:            \n"
   "lodsb                   \n"
   "stosb                   \n"
   "testb $255,%%al         \n"
   "jz    STRNCPY_fim       \n"
   "loop  STRNCPY_prox      \n"
   "inc  %%rsi              \n"
  "STRNCPY_fim:             \n"
   "movb  $0,(%%rdi)        \n"
   "sub  %%rbx,%%rsi        \n"
   "dec  %%rsi              \n"   
   "mov  %%rsi,%3           \n"
   :
   :"m"(destino), "m"(origem), "c"(tam_str), "m"(ret_val)
   :"rdi", "rsi", "ax", "rbx"
  );
 #else
  asm(
   "movl  %0,%%edi          \n"
   "movl  %1,%%esi          \n"
   "movl  %%esi,%%ebx       \n"
  "STRNCPY_prox:            \n"
   "lodsb                   \n"
   "stosb                   \n"
   "testb $255,%%al         \n"
   "jz    STRNCPY_fim       \n"
   "loop  STRNCPY_prox      \n"
   "incl  %%esi             \n"
  "STRNCPY_fim:             \n"
   "movb  $0,(%%edi)        \n"
   "subl  %%ebx,%%esi       \n"
   "decl  %%esi             \n"   
   "movl  %%esi,%3          \n"
   :
   :"m"(destino), "m"(origem), "c"(tam_str), "m"(ret_val)
   :"edi", "esi", "ax", "ebx"
  );
 #endif
 
 return ret_val;
}



//---------------------------------------------------
//Funcao para comparar duas strings desconciderando  
//a diferena entre maisculas e minsculas          
//Retornos:                                          
//0 = strings so iguais                             
//1 = strings so diferentes                         
int cmp_str(char *string1,char *string2,int num_bytes){
 if(!num_bytes){
  if(string1[0]==string2[0])return 0;
  return 1;
 }
 int ret_val=0;

 #ifdef A64
  asm(
   "mov  %0,%%rdi           \n"
   "mov  %1,%%rsi           \n"
  "CMP_STR_proxbyte:        \n"
   "mov  (%%rsi),%%al       \n"
   "cmp  (%%rdi),%%al       \n"
   "jne  CMP_STR_trocar     \n"
  "CMP_STR_incr:            \n"
   "inc  %%rsi              \n"
   "inc  %%rdi              \n"
   "loop CMP_STR_proxbyte   \n"
   "jmp  CMP_STR_term       \n"
  "CMP_STR_trocar:          \n"
   "xor  $32,%%al           \n"
   "cmp  (%%rdi),%%al       \n"
   "je   CMP_STR_incr       \n"
  "CMP_STR_term:            \n"
   "test  %%cx,%%cx         \n"
   "jz   CMP_STR_fim        \n"
   "mov  $1,%%cx            \n"
  "CMP_STR_fim:             \n"
   "mov   %%cx,%3           \n"
   :
   :"m"(string1),"m"(string2),"c"(num_bytes),"m"(ret_val)
   :"rdi","rsi","rax"
  );
 #else
  asm(
   "movl %0,%%edi           \n"
   "movl %1,%%esi           \n"
  "CMP_STR_proxbyte:        \n"
   "movb (%%esi),%%al       \n"
   "cmpb (%%edi),%%al       \n"
   "jne  CMP_STR_trocar     \n"
  "CMP_STR_incr:            \n"
   "incl %%esi              \n"
   "incl %%edi              \n"
   "loop CMP_STR_proxbyte   \n"
   "jmp  CMP_STR_term       \n"
  "CMP_STR_trocar:          \n"
   "xorb $32,%%al           \n"
   "cmpb (%%edi),%%al       \n"
   "je   CMP_STR_incr       \n"
  "CMP_STR_term:            \n"
   "testw %%cx,%%cx         \n"
   "jz   CMP_STR_fim        \n"
   "movw $1,%%cx            \n"
  "CMP_STR_fim:             \n"
   "movw  %%cx,%3           \n"
   :
   :"m"(string1),"m"(string2),"c"(num_bytes),"m"(ret_val)
   :"edi","esi","eax"
  );
 #endif
 return ret_val;
}


//---------------------------------------------------
//Funcao para converter um texto em minusculo        
void minuscular(char *string1){
 
 #ifdef A64
  asm(
   "mov  %0,%%rdi           \n"
   "dec  %%rdi              \n"
  "Minusc_prox_byte:        \n"
   "inc  %%rdi              \n"
   "cmpb $0,(%%rdi)         \n" 
   "je   Minusc_fim         \n"
   "cmpb $65,(%%rdi)        \n" 
   "jb   Minusc_prox_byte   \n"
   "cmpb $90,(%%rdi)        \n"
   "ja   Minusc_prox_byte   \n"
   "orb  $32,(%%rdi)        \n"
   "jmp  Minusc_prox_byte   \n"
   "Minusc_fim:             \n"
   :
   :"m"(string1)
   :"rdi","rax"
  );
 #else 
  asm(
   "movl %0,%%edi           \n"
   "decl %%edi              \n"
  "Minusc_prox_byte:        \n"
   "incl %%edi              \n"
   "cmpb $0,(%%edi)         \n" 
   "je   Minusc_fim         \n"
   "cmpb $65,(%%edi)        \n" 
   "jb   Minusc_prox_byte   \n"
   "cmpb $90,(%%edi)        \n"
   "ja   Minusc_prox_byte   \n"
   "orb  $32,(%%edi)        \n"
   "jmp  Minusc_prox_byte   \n"
   "Minusc_fim:             \n"
   :
   :"m"(string1)
   :"edi","eax"
  );
 #endif
}


//--- Variavel de controle 
//    da funcao cpl        
unsigned int tamanho=TAM_buffer;
char *cpl_orig;
char *cpl_dest;

//---------------------------------------------------
// Separa em linhas um buffer texto                  
// Retornos:                                         
// 0 = Linha copiada com sucesso                     
// 1 = Fim de buffer, leia um novo buffer            
// Obs: O buffer apontado por cpl_orig deve terminar 
// com o valor 0 (ZERO)                              
int cpl(unsigned int *tamanho,unsigned int limite){
 int ret_val=0;
 
 #ifdef A64
  asm(
   "mov  %1,%%rdi           \n"
   "mov  %2,%%rsi           \n"
   "mov  %3,%%ecx           \n"
   "test  %%ecx,%%ecx       \n"
   "jz CPL_arrumar          \n"
  "CPL_volta:               \n"
   "mov  (%%rsi),%%al       \n"
   "inc  %%rsi              \n"
   "cmp  $10,%%al           \n"
   "je CPL_finalizar        \n"
   "test  %%al,%%al         \n"
   "jz CPL_zero             \n"
   "mov  %%al,(%%rdi)       \n"
   "inc  %%rdi              \n"
   "loop CPL_volta          \n"
  "CPL_arrumar:             \n"      // Limite da linha atingido
   "mov  (%%rsi),%%al       \n"
   "inc  %%rsi              \n"
   "cmp  $10,%%al           \n"
   "jne CPL_ar_prox         \n"
  "CPL_finalizar:           \n"
   "mov  %4,%%ecx           \n"
   "jmp CPL_fim             \n"
  "CPL_ar_prox:             \n"
   "test  %%al,%%al         \n"
   "jnz CPL_arrumar         \n"
  "CPL_zero:                \n"
   "movw  $1,%5             \n"
  "CPL_fim:                 \n"
   "movb $0,(%%rdi)         \n"
   "mov  %%rdi,%1           \n"
   "mov  %%rsi,%2           \n"
   "mov  %%ecx,%0           \n"
  
   :"=r"(*tamanho)
   :"m"(cpl_dest),"m"(cpl_orig),"r"(*tamanho),"r"(limite),"m"(ret_val)
   :"rax","rdi","rsi","rcx"
  );
 #else 
  asm(
   "movl %1,%%edi           \n"
   "movl %2,%%esi           \n"
   "movl %3,%%ecx           \n"
   "testl %%ecx,%%ecx       \n"
   "jz CPL_arrumar          \n"
  "CPL_volta:               \n"
   "movb (%%esi),%%al       \n"
   "incl %%esi              \n"
   "cmpb $10,%%al           \n"
   "je CPL_finalizar        \n"
   "testb %%al,%%al         \n"
   "jz CPL_zero             \n"
   "movb %%al,(%%edi)       \n"
   "incl %%edi              \n"
   "loop CPL_volta          \n"
  "CPL_arrumar:             \n"      // Limite da linha atingido
   "movb (%%esi),%%al       \n"
   "incl %%esi              \n"
   "cmpb $10,%%al           \n"
   "jne CPL_ar_prox         \n"
  "CPL_finalizar:           \n"
   "movl %4,%%ecx           \n"
   "jmp CPL_fim             \n"
  "CPL_ar_prox:             \n"
   "testb %%al,%%al         \n"
   "jnz CPL_arrumar         \n"
  "CPL_zero:                \n"
   "movw $1,%5              \n"
  "CPL_fim:                 \n"
   "movb $0,(%%edi)         \n"
   "movl %%edi,%1           \n"
   "movl %%esi,%2           \n"
   "movl %%ecx,%0           \n"
  
   :"=r"(*tamanho)
   :"m"(cpl_dest),"m"(cpl_orig),"r"(*tamanho),"r"(limite),"m"(ret_val)
   :"eax","edi","esi","ecx"
  );
 #endif
 return ret_val;
}

//---------------------------------------------------
// Le uma resp. de um PIPE                           
// Retornos:                                         
// Tamanho da resposta                               
// -1 = Erro                                         
int read_pipe(int npipe, char *buffer_local, int nbytes){
 int tam_total=0;
 int b_lidos;
 
 do{
  b_lidos=read(npipe, buffer_local, nbytes);
  if(!b_lidos)return tam_total;
  if(b_lidos < 0)return b_lidos;
  buffer_local+=b_lidos;
  tam_total+=b_lidos;
 }while(buffer_local[-1] != 10);
 *buffer_local=0;
 return tam_total;
}



//---------------------------------------------------
// Conversa com o modulo externo para pegar a senha  
// do usuario                                        
char *ret_password(char *user){
 static char buffer_local[TAM_buffer + 1];
 int b_lidos=0;
 
 b_lidos=snprintf(buffer_local, TAM_buffer-10, "pass %s\n", user);
 write(mod_pipe MOD_write, buffer_local, b_lidos);
 b_lidos=read_pipe(mod_pipe MOD_read, buffer_local, TAM_buffer);
 if(b_lidos > 0){
  buffer_local[--b_lidos]=0;
  if(buffer_local[0] == '+')return &buffer_local[4];
 }
 //Erro lendo PIPE ou usuario nao encontrado
 return NULL;
}


//---------------------------------------------------
// Funcoes chamadas pela DLlib. Obrigatorias
void _init();  // Chamada quando o modulo  carregado 
void _fini();  // Chamada quando o modulo  desativado


//======================================================
// Funcao chamada pelo MTA assim que  carregado. Igual 
// a _init, porm, aceita um parametro que pode ser um  
// arquivo de configuracao a ler.  o parametro passado 
// dentro do selor.conf                                 
// Retornos:                                            
// 0 = Sem erros, modulo carregado                      
// 1 = Erro                                             
char mod_init(char *param, char *module_name, char *module_version, char *info, int info_buf_size){
 FILE *arq_conf;
 char *ptr_aux1=NULL;
 int b_lidos=0;
 
 
 arq_conf=fopen(param, "rb");
 if(!arq_conf){
  snprintf(msg_error, TAM_msg_error, "Couldn't open file %s", param);
  return 1;
 }
 cpl_dest=linha;
 tamanho=TAM_buffer;
 while(!feof(arq_conf)){
  b_lidos=fread(&buffer, 1, TAM_buffer, arq_conf);
  if(b_lidos < 0){
   snprintf(msg_error, TAM_msg_error, "Error reading file %s", param);
   fclose(arq_conf);
   return 1;
  }
  buffer[b_lidos]=0;
  cpl_orig=buffer;
  while(!cpl(&tamanho, TAM_buffer)){
   cpl_dest=linha;
   if(!cmp_str(linha, "Local_domains=", 14)){
    ptr_aux1=&linha[14];
    while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
    snprintf(local_domains, TAM_cam_op, "%s", ptr_aux1);
   }else if(!cmp_str(linha, "Alias_list=", 11)){
    ptr_aux1=&linha[11];
    while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
    snprintf(alias_list, TAM_cam_op, "%s", ptr_aux1);
   }else if(!cmp_str(linha, "Quota_list=", 11)){
    ptr_aux1=&linha[11];
    while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
    snprintf(quota_list, TAM_cam_op, "%s", ptr_aux1);
   }else if(!cmp_str(linha, "Default_quota=", 14)){
    ptr_aux1=&linha[14];
    while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
    default_quota=atoi(ptr_aux1);
   }else if(!cmp_str(linha, "Mailbox_path=", 13)){
    ptr_aux1=&linha[13];
    while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
    snprintf(mailbox_path, TAM_cam_op, "%s", ptr_aux1);
   }else if(!cmp_str(linha, "User_home=", 10)){
    ptr_aux1=&linha[10];
    while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
    snprintf(user_home, TAM_cam_op, "%s", ptr_aux1);
   }else if(!cmp_str(linha, "System_users=", 13)){
    ptr_aux1=&linha[13];
    while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
    if(!cmp_str(ptr_aux1, "yes\0", 4))system_users=1;
    else if(*ptr_aux1 == '1' && !ptr_aux1[1])system_users=1;
   }else if(!cmp_str(linha, "Pwdpipe_mod=", 12)){
    ptr_aux1=&linha[12];
    while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
    snprintf(pwdpipe_mod, TAM_cam_op, "%s", ptr_aux1);
   }
  }
 }
 fclose(arq_conf);
 if(!(arq_domains=fopen(local_domains, "rb"))){
  snprintf(msg_error, TAM_msg_error, "Couldn't open 'local_domains' file [%s]", local_domains);
  return 1;
 }
 arq_alias=fopen(alias_list, "rb");
 arq_quota=fopen(quota_list, "rb");
 
 // O caminho do modulo auxiliar nao foi especificado
 if(!pwdpipe_mod[0]){
  strcpy(msg_error, "You need to specify the path of pwdpipe_mod in configuration file.");
  return 1;
 }
 
 // Criando processo PIPE para responder a senhas protegidas
 if(pipe(mod_pipe[0]) == -1 || pipe(mod_pipe[1]) == -1){
  strcpy(msg_error, "Couldn't create PIPEs for pwdpipe_mod.");
  return 1;
 }
 pid_pwdpipe=fork();
 if(!pid_pwdpipe && !geteuid()){
  // MODULO Criado
  close(0);        // Fechando STDIN 
  close(1);        // Fechando STDOUT
  dup2(mod_pipe[0][0], 0);    // --> ENTRADA de texto para o Modulo 
  dup2(mod_pipe[1][1], 1);    // --> SAIDA de texto do Modulo       
  execv(pwdpipe_mod, mod_param);
  printf("Couldn't execute pwdpipe_mod.");
  exit(1);
 }else if(pid_pwdpipe < 0){
  strcpy(msg_error, "Fork error.");
  return 1;
 }
 b_lidos=read_pipe(mod_pipe MOD_read, buffer, TAM_buffer);
 buffer[b_lidos]=0;
 if(buffer[0] != '+'){
  buffer[b_lidos-1]=0;     // Retirando o \n do final para nao detornar o log selor_wrn.log
  local_strncpy(msg_error, buffer, TAM_msg_error);
  kill(pid_pwdpipe, SIGTERM);
  return 1;
 }
 strcpy(module_name, MOD_NAME);
 strcpy(module_version, VERSAO);
 return 0;
}

//======================================================
// Checa se o dominio  local ou nao                    
// Retornos:                                            
// 0 = Nao  local                                      
// 1 = Dominio  local                                  
char mod_dom_local(char *dominio, char *ret_dom){
 char *ptr_aux1;
 int tam_dom;
 int b_lidos=0;
 
 tam_dom=strlen(dominio);
 fseek(arq_domains, 0, 0);
 cpl_dest=linha;
 tamanho=TAM_buffer;
 while(!feof(arq_domains)){
  b_lidos=fread(&buffer, 1, TAM_buffer, arq_domains);
  if(b_lidos < 0)return 0;     //Nao foi possivel ler o arquivo
  buffer[b_lidos]=0;
  cpl_orig=buffer;
  while(!cpl(&tamanho, TAM_buffer)){
   cpl_dest=linha;
   if(!cmp_str(linha, dominio, tam_dom)){
    ptr_aux1=&linha[tam_dom];
    if(!(*ptr_aux1)){
     *ret_dom=0;
     return 1;
    }
    else if(*ptr_aux1 == ' ' || *ptr_aux1 == 9){
     // Dominio ALIAS
     while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
     strcpy(ret_dom, ptr_aux1);
     return 1;
    }
   }
  }
 }
 
 return 0;
}

//======================================================
// Checa se o email  local ou nao                      
// Retornos:                                            
// 0 = Nao existe                                       
// 1 = Email existe                                     
char mod_user_local(char *email, char *info[], int num_campos){
 char *ptr_aux1=NULL;
 char *ptr_aux2=NULL;
 
 
 if((ptr_aux1=strchr(email, '@'))){
  if(system_users)*ptr_aux1=0;
  else return 0;
 }
 if(!cmp_str(cache_user, email, tam_user+1)){
  info[MOD_user_user]=cache_user;
  info[MOD_user_pass]=cache_pass;
  info[MOD_user_home]=cache_home;
  info[MOD_user_dlocal]=cache_dlocal;
  if(ptr_aux1)*ptr_aux1='@';
  return 1;
 }
 pwd=getpwnam(email);
 if(pwd){
  // Usuario existe
  #ifndef FreeBSD
   if(strcmp(pwd->pw_passwd, "x"))local_strncpy(cache_pass, pwd->pw_passwd, TAM_pass);
   else {
  #endif
   if(!(ptr_aux2=ret_password(email))){
    // Usuario nao existe
    if(ptr_aux1)*ptr_aux1='@';
    return 0;
   }
   local_strncpy(cache_pass, ptr_aux2, TAM_pass);
  #ifndef FreeBSD
   }
  #endif
  tam_user=local_strncpy(cache_user, email, TAM_user);
  snprintf(cache_home, TAM_home, "%s/%s", user_home, email);
  info[MOD_user_user]=cache_user;
  info[MOD_user_pass]=cache_pass;
  info[MOD_user_home]=cache_home;
  info[MOD_user_dlocal]=cache_dlocal;
  if(ptr_aux1)*ptr_aux1='@';
  return 1;
 }
 // Usuario nao existe
 if(ptr_aux1)*ptr_aux1='@';
 return 0;
}


//======================================================
// Retorna os alias                                     
// Retornos:                                            
// 0 = Nenhum alinas encontrado                         
// -1 = Erro                                            
// <numero de alias no buffer>                          
int mod_ret_alias(char *email, char *buffer_ret, int num_itens, int tam_item_buffer, unsigned int *prox_bloco){
 char *ptr_aux1;
 char *ptr_aux2;
 int tam_email;
 int b_lidos=0;
 
 if(!arq_alias)return 0;
 num_alias=0;
 atual_alias=0;
 tam_email=strlen(email);
 fseek(arq_alias, *prox_bloco, 0);       //Deixando arquivo na posicao
 cpl_dest=linha;
 tamanho=TAM_buffer;
 while(!feof(arq_alias)){
  b_lidos=fread(&buffer, 1, TAM_buffer, arq_alias);
  if(b_lidos < 1)return 0;     //Nao foi possivel ler o arquivo
  buffer[b_lidos]=0;
  cpl_orig=buffer;
  while(!cpl(&tamanho, TAM_buffer) && num_alias < num_itens){
   cpl_dest=linha;
   if(!cmp_str(linha, email, tam_email)){
    // Alias encontrado
    ptr_aux2=cpl_orig;
    ptr_aux1=&linha[tam_email];
    if(*ptr_aux1 == ' ' || *ptr_aux1 == 9){
     while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
     local_strncpy(buffer_ret, ptr_aux1, TAM_alias_regs);
     buffer_ret+=tam_item_buffer;
     num_alias++;
    }
   }
  }
 }
 *prox_bloco=ftell(arq_alias)-b_lidos+(ptr_aux2-buffer);       // Determinando a posicao do arquivo
 return num_alias;
}



//======================================================
// Checa o usuario e senha passado                      
// Retornos:                                            
// 0 = Usuario nao encontrado                           
// 1 = Senha correta                                    
// 2 = Senha incorreta                                  
// -1 = Erro                                            
char mod_auth(char *email, char *senha, char *info[], int num_campos){
 char tmp_email[TAM_user];
 char ret=0;
 char *ptr_aux1;
 int num_alias=0;
 unsigned int prox_bloco=0;
 
 
 if((ptr_aux1=strchr(email, '@'))){
  // Descobrindo qual e' usuario do alias
  num_alias=mod_ret_alias(email, tmp_email, 1, TAM_user, &prox_bloco);
  if(num_alias > 0)ptr_aux1=tmp_email;
 }else ptr_aux1=email;
 
 if(!(ret=mod_user_local(ptr_aux1, info, num_campos)))return 0; // Usurio nao existe
 else if(ret < 0)return ret;
 if(!strcmp((char *)crypt(senha, cache_pass), cache_pass))return 1;
 
 return 2;
}

//======================================================
// Checa o usuario e senha passado                      
// Retornos:                                            
// 0 = Usuario nao encontrado                           
// 1 = Quota nao excedida                               
// 2 = Quota excedida                                   
char mod_test_quota(char *email, char *info[], int num_campos){
 DIR *dir;
 struct dirent *entr;
 struct stat dados_arq;
 char buffer_local[TAM_buffer];
 char *ptr_aux1;
 int b_lidos=0;
 int tam_str=0;
 unsigned long long int tam_total=0;
 unsigned long long int quota_maxima=0;
 
 
 tam_str=strlen(email);
 quota_maxima=default_quota;
 // -- Procurando q quota do email --
 if(arq_quota){
  fseek(arq_quota, 0, 0); // 'Rebobinando' arquivo de quota
  cpl_dest=linha;
  tamanho=TAM_buffer;
  while(!feof(arq_quota)){
   b_lidos=fread(&buffer, 1, TAM_buffer, arq_quota);
   buffer[b_lidos]=0;
   cpl_orig=buffer;
   while(!cpl(&tamanho, TAM_buffer)){
    cpl_dest=linha;
    if(!cmp_str(linha, email, tam_str)){
     ptr_aux1=&linha[tam_str];
     while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
     quota_maxima=atoi(ptr_aux1);
     goto Limite_encontrado;
    }
   }
  }
 }
 Limite_encontrado:
 
 if((ptr_aux1=strchr(email, '@')))*ptr_aux1=0;
 
 // -- Medindo o espaco usado pela conta --
 snprintf(buffer_local, TAM_buffer-1,"%s/%s", mailbox_path, email);
 if(ptr_aux1)*ptr_aux1='@';
 if(!stat(buffer_local, &dados_arq))tam_total=dados_arq.st_size;
 if(user_home[0]){
  snprintf(buffer_local, TAM_buffer-1,"%s/%s", user_home, email);
  dir=opendir(buffer_local);
  if(dir){
   while((entr=readdir(dir))){
    snprintf(buffer_local, TAM_buffer-1, "%s/%s/%s", user_home, email, entr->d_name);
    if(!stat(buffer_local, &dados_arq))if(!(dados_arq.st_mode & S_IFDIR))tam_total+=dados_arq.st_size;
   }
   closedir(dir);
  }
 }
 
 if(tam_total >= quota_maxima)return 2;
 return 1;
}


//======================================================
// Finaiza o modulo  
char *mod_shutdown(void){
 
 write(mod_pipe MOD_write, "quit\n", 5);
 return 0;
}

//======================================================
// Funcao para retornar um ponteiro contendo uma        
// mensagem de erro                                     
char *mod_msg_error(void){
 return &msg_error[0];
}




/*
 if(pwd){
  // Usuario existe
  
  
  #ifdef FreeBSD
   local_strncpy(cache_pass, pwd->pw_passwd, TAM_pass);
  #else
   if(strcmp(pwd->pw_passwd, "x"))local_strncpy(cache_pass, pwd->pw_passwd, TAM_pass);
   else {
    if(!(ptr_aux2=linux_ret_shadow(email))){
     // Usuario nao existe
     if(ptr_aux1)*ptr_aux1='@';
     return 0;
    }
    local_strncpy(cache_pass, ptr_aux2, TAM_pass);
   }
  #endif
  tam_user=local_strncpy(cache_user, email, TAM_user);
  snprintf(cache_home, TAM_home, "%s/%s", user_home, email);
  info[MOD_user_user]=cache_user;
  info[MOD_user_pass]=cache_pass;
  info[MOD_user_home]=cache_home;
  info[MOD_user_dlocal]=cache_dlocal;
  if(ptr_aux1)*ptr_aux1='@';
  return 1;
 }
 */






















