/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   SUB MODULO selor_pwdpipe apenas para Linux                                    
   Programado por Lucas Priori                                                   
   Versao: 1.00                                                                  
                                                                                 
  Linux:                                                                         
  gcc selor_pwdpipe.c -o selor_pwdpipe -lcrypt -Wall                             
                                                                                 
  FreeBSD:                                                                       
  gcc selor_pwdpipe.c -o selor_pwdpipe -lcrypt -DFreeBSD -Wall                   
                                                                                 
  *****************************************************************************  
  Este programa  um modulo auxiliar ao selor_passwd usado para pegar            
  a senhas em formato shadow no Linux e senhas seguras no FreeBSD                
  Copyright (C) 2013,2014  Lucas Priori                                          
                                                                                 
  This program is free software; you can redistribute it and/or                  
  modify it under the terms of the GNU General Public License                    
  as published by the Free Software Foundation; either version 2                 
  of the License, or (at your option) any later version.                         
                                                                                 
  This program is distributed in the hope that it will be useful,                
  but WITHOUT ANY WARRANTY; without even the implied warranty of                 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                  
  GNU General Public License for more details.                                   
                                                                                 
  You should have received a copy of the GNU General Public License              
  along with this program; if not, write to the Free Software                    
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
#include<stdio.h>
#include<string.h>
#include<pwd.h>
#ifdef FreeBSD
 #include<rpcsvc/crypt.h>
#else
 #include<crypt.h>
 #include<shadow.h>
#endif

#define TAM_usuario 300


//======================================================
int main(){
 #ifndef FreeBSD
  struct spwd *pwds;
 #else
  struct passwd *pwd;
 #endif
 char byte=0;
 char cmd[TAM_usuario + 1];
 char *ptr_aux1;
 unsigned int cont1=0;
 
 setbuf(stdout,NULL);
 printf("+OK selor_shadowmod ready\n");
 while((byte=fgetc(stdin)) != EOF){
  cmd[cont1++]=byte;
  if(cont1 >= TAM_usuario){
   printf("-ERROR Cmd too big\n");
   cmd[0]=0;
   cont1=0;
   continue;
  }
  if(byte == 10){
   cmd[--cont1]=0;
   if(!strncmp(cmd, "pass ", 5)){
    ptr_aux1=&cmd[5];
    if(strcmp(ptr_aux1, "root") && *ptr_aux1){
     #ifdef FreeBSD
      pwd=getpwnam(ptr_aux1);
      if(pwd)ptr_aux1=pwd->pw_passwd;
      else ptr_aux1=NULL;
     #else
      pwds=getspnam(ptr_aux1);
      if(pwds)ptr_aux1=pwds->sp_pwdp;
      else ptr_aux1=NULL;
     #endif
     if(ptr_aux1)printf("+OK %s\n", ptr_aux1);
     else printf("-ERROR User not found\n");
    }else printf("-ERROR User not found\n");
   }else if(!strcmp(cmd, "quit"))return 0;
   else printf("-ERROR Command not found\n");
   cont1=0;
   cmd[0]=0;
  }
 }
 return 0;
}









