/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   SELOR_DKIM - Utilitario para geracao de assinaturas DKIM                      
   Programado por Lucas Priori                                                   
   Versao: 1.0                                                                   
                                                                                 
   Linux  32Bits: gcc selor_dkim.c -o selor_dkim -lssl -lmysqlclient             
   Linux  64Bits: gcc selor_dkim.c -o selor_dkim -DA64 -lssl -lmysqlclient       
                                                                                 
   FreeBSD  32Bits: gcc selor_dkim.c -o selor_dkim -DFreeBSD -lssl -lmysqlclient 
   FreeBSD  64Bits: gcc selor_dkim.c -o selor_dkim -DFreeBSD -L/usr/local/lib/mysql -DA64 -lssl -lmysqlclient
                                                                                 
   Para gerar uma chave privada e publica usando openssl:                        
     openssl genrsa -out dkim_private.key 1024                                   
     openssl rsa -pubout -in dkim_private.key  -out dkim_public.key              
                                                                                 
  *******************************************************************            
  Selor_dkim e´ utilitario para gerar assinaturas DKIM para emails do MTA Selor  
  Copyright (C) 2014,2015 Lucas Priori                                           
                                                                                 
  This program is free software; you can redistribute it and/or                  
  modify it under the terms of the GNU General Public License                    
  as published by the Free Software Foundation; either version 2                 
  of the License, or (at your option) any later version.                         
                                                                                 
  This program is distributed in the hope that it will be useful,                
  but WITHOUT ANY WARRANTY; without even the implied warranty of                 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                  
  GNU General Public License for more details.                                   
                                                                                 
  You should have received a copy of the GNU General Public License              
  along with this program; if not, write to the Free Software                    
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/


// -------------------------------------------------------------
// Retornos:                                                    
// 0 = Sucesso. Dkim gerado com sucesso                         
// 1 = Dkim não foi gerado por nao haver um seletor ou chave    
// 2 = Erro                                                     

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<sys/stat.h>
#include<openssl/sha.h>
#include<openssl/rsa.h>
#include<openssl/pem.h>
#include<openssl/bio.h>
#include<openssl/err.h>
#ifdef FreeBSD
 #include<rpcsvc/crypt.h>
 #include "/usr/local/include/mysql/mysql.h"
 #include "/usr/local/include/mysql/errmsg.h"
#else
 #include<crypt.h>
 #include<mysql/mysql.h>
 #include<mysql/errmsg.h>
#endif


#define VERSAO "1.0"
#define TAM_file_path 200
#define TAM_buffer 2048
#define TAM_buffer_campos
#define TAM_seletor 50
#define MAX_hf 50
#define TAM_hf 100
#define TAM_str_confs 100
#define TAM_query_conf 1000
//#define MAX_body_default 1048576  // 1 MB
#define MAX_body_default 10485760  // 10 MB




char tab_base64[65]=
{ 'A','B','C','D','E','F','G','H','I','J','K','L','M',
  'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
  'a','b','c','d','e','f','g','h','i','j','k','l','m',
  'n','o','p','q','r','s','t','u','v','w','x','y','z',
  '0','1','2','3','4','5','6','7','8','9','+','/', 0
};

// -- Estruturas do MySQL --
MYSQL *mysql;
MYSQL_RES *myres; 
MYSQL_ROW myreg;

// --
char buffer[TAM_buffer+2];
char linha[TAM_buffer+2];
// --
char op_gen[TAM_file_path];
char op_s[TAM_seletor];
char op_h[MAX_hf][TAM_hf];
char op_d[MAX_hf];
char op_pkey[TAM_file_path];
char op_dbconf[TAM_file_path];
unsigned int op_max_body=MAX_body_default;  // Padrao 1 MB
int op_h_sequence[MAX_hf];
// -- Opcoes do arquivo de configuracao --
char op_conf_host[TAM_str_confs];
unsigned short op_conf_port=3306;
char op_conf_user[TAM_str_confs];
char op_conf_pass[TAM_str_confs];
char op_conf_db[TAM_str_confs];
char op_conf_query[TAM_query_conf];
// --
 
//--- Variavel de controle 
//    da funcao cpl        
unsigned int tamanho=TAM_buffer;
char *cpl_orig;
char *cpl_dest;

//---------------------------------------------------
// Separa em linhas um buffer texto                  
// Retornos:                                         
// 0 = Linha copiada com sucesso                     
// 1 = Fim de buffer, leia um novo buffer            
// Obs: O buffer apontado por cpl_orig deve terminar 
// com o valor 0 (ZERO)                              
int cpl(unsigned int *tamanho,unsigned int limite){
 int ret_val=0;
 
 #ifdef A64
  asm(
   "mov  %1,%%rdi           \n"
   "mov  %2,%%rsi           \n"
   "xor  %%rcx, %%rcx       \n"
   "mov  %3,%%ecx           \n"
   "test  %%ecx,%%ecx       \n"
   "jz CPL_arrumar          \n"
  "CPL_volta:               \n"
   "mov  (%%rsi),%%al       \n"
   "inc  %%rsi              \n"
   "cmp  $10,%%al           \n"
   "je CPL_finalizar        \n"
   "test  %%al,%%al         \n"
   "jz CPL_zero             \n"
   "cmp  $13,%%al           \n"
   "je  CPL_codigo_13       \n"
   "mov  %%al,(%%rdi)       \n"
   "inc  %%rdi              \n"
  "CPL_codigo_13:           \n"
   "loop CPL_volta          \n"
  "CPL_arrumar:             \n"      // Limite da linha atingido
   "mov  (%%rsi),%%al       \n"
   "inc  %%rsi              \n"
   "cmp  $10,%%al           \n"
   "jne CPL_ar_prox         \n"
  "CPL_finalizar:           \n"
   "mov  %4,%%ecx           \n"
   "jmp CPL_fim             \n"
  "CPL_ar_prox:             \n"
   "test  %%al,%%al         \n"
   "jnz CPL_arrumar         \n"
  "CPL_zero:                \n"
   "movw $1,%5              \n"
  "CPL_fim:                 \n"
   "movb $0,(%%rdi)         \n"
   "mov  %%rdi,%1           \n"
   "mov  %%rsi,%2           \n"
   "mov  %%ecx,%0           \n"
   :"=r"(*tamanho)
   :"m"(cpl_dest),"m"(cpl_orig),"r"(*tamanho),"r"(limite),"m"(ret_val)
   :"rax","rdi","rsi","rcx"
  );
 #else
  asm(
   "movl %1,%%edi           \n"
   "movl %2,%%esi           \n"
   "movl %3,%%ecx           \n"
   "testl %%ecx,%%ecx       \n"
   "jz CPL_arrumar          \n"
  "CPL_volta:               \n"
   "movb (%%esi),%%al       \n"
   "incl %%esi              \n"
   "cmpb $10,%%al           \n"
   "je CPL_finalizar        \n"
   "testb %%al,%%al         \n"
   "jz CPL_zero             \n"
   "cmpb $13,%%al           \n"
   "je  CPL_codigo_13       \n"
   "movb %%al,(%%edi)       \n"
   "incl %%edi              \n"
  "CPL_codigo_13:           \n"
   "loop CPL_volta          \n"
  "CPL_arrumar:             \n"      // Limite da linha atingido
   "movb (%%esi),%%al       \n"
   "incl %%esi              \n"
   "cmpb $10,%%al           \n"
   "jne CPL_ar_prox         \n"
  "CPL_finalizar:           \n"
   "movl %4,%%ecx           \n"
   "jmp CPL_fim             \n"
  "CPL_ar_prox:             \n"
   "testb %%al,%%al         \n"
   "jnz CPL_arrumar         \n"
  "CPL_zero:                \n"
   "movw $1,%5              \n"
  "CPL_fim:                 \n"
   "movb $0,(%%edi)         \n"
   "movl %%edi,%1           \n"
   "movl %%esi,%2           \n"
   "movl %%ecx,%0           \n"
   :"=r"(*tamanho)
   :"m"(cpl_dest),"m"(cpl_orig),"r"(*tamanho),"r"(limite),"m"(ret_val)
   :"eax","edi","esi","ecx"
  );
  #endif
 return ret_val;
}


//---------------------------------------------------
//Funcao para comparar duas strings desconciderando  
//a diferença entre maiusculas e minusculas          
//Retornos:                                          
//0 = strings são iguais                             
//1 = strings são diferentes                         
int cmp_str(char *string1, char *string2, int num_bytes){
 if(!num_bytes){
  if(*string1==*string2)return 0;
  return 1;
 }
 int ret_val=0;
 #ifdef A64
  asm(
   "mov  %0,%%rdi           \n"
   "mov  %1,%%rsi           \n"
  "CMP_STR_proxbyte:        \n"
   "movb (%%rsi),%%al       \n"
   "cmpb (%%rdi),%%al       \n"
   "jne  CMP_STR_trocar     \n"
  "CMP_STR_incr:            \n"
   "inc  %%rsi              \n"
   "inc  %%rdi              \n"
   "loop CMP_STR_proxbyte   \n"
   "jmp  CMP_STR_term       \n"
  "CMP_STR_trocar:          \n"
   "xorb $32,%%al           \n"
   "cmpb (%%rdi),%%al       \n"
   "je   CMP_STR_incr       \n"
  "CMP_STR_term:            \n"
   "testw %%cx,%%cx         \n"
   "jz   CMP_STR_fim        \n"
   "movw $1,%%cx            \n"
  "CMP_STR_fim:             \n"
   "movw  %%cx,%3           \n"
   :
   :"m"(string1),"m"(string2),"c"(num_bytes),"m"(ret_val)
   :"rdi","rsi","rax"
  );
 #else
  asm(
   "movl %0,%%edi           \n"
   "movl %1,%%esi           \n"
  "CMP_STR_proxbyte:        \n"
   "movb (%%esi),%%al       \n"
   "cmpb (%%edi),%%al       \n"
   "jne  CMP_STR_trocar     \n"
  "CMP_STR_incr:            \n"
   "incl %%esi              \n"
   "incl %%edi              \n"
   "loop CMP_STR_proxbyte   \n"
   "jmp  CMP_STR_term       \n"
  "CMP_STR_trocar:          \n"
   "xorb $32,%%al           \n"
   "cmpb (%%edi),%%al       \n"
   "je   CMP_STR_incr       \n"
  "CMP_STR_term:            \n"
   "testw %%cx,%%cx         \n"
   "jz   CMP_STR_fim        \n"
   "movw $1,%%cx            \n"
  "CMP_STR_fim:             \n"
   "movw  %%cx,%3           \n"
   :
   :"m"(string1),"m"(string2),"c"(num_bytes),"m"(ret_val)
   :"edi","esi","eax"
  );
 #endif
 return ret_val;
}

//---------------------------------------------------
void base64_cod(char *retorno, char *str_normal, int tamanho){
 char *base=tab_base64;
 #ifdef A64
  asm(
   "xor  %%edx,%%edx            \n" 
   "push %%rbx                  \n"
   "mov  $3,%%ebx               \n"
   "div  %%ebx                  \n"
   "pop  %%rbx                  \n"
   "mov  %%eax,%%ecx            \n"
   "push %%dx                   \n"
   "test %%dl,%% dl             \n"
   "jz   CODI_Pular             \n" 
   "inc  %%ecx                  \n"
  "CODI_Pular:                  \n"
   "mov  %0,%%rdi               \n"
   "mov  %1,%%rsi               \n"
  "CODI_Prox_casa:              \n"
   "push  %%rcx                 \n"
   "mov  (%%rsi),%%eax          \n"
   "ror  $8,%%ax                \n"
   "ror  $16,%%eax              \n"
   "ror  $8,%%ax                \n"
   "shr  $8,%%eax               \n"
   "mov  $4,%%cx                \n"
   "shl  $2,%%eax               \n"
   "add  $4,%%rdi               \n"
  "CODI_Prox_byte:              \n"
   "shr  $2,%%al                \n"
   "xlatb                       \n"
   "dec  %%rdi                  \n"
   "mov  %%al,(%%rdi)           \n"
   "shr  $6,%%eax               \n"
   "loop CODI_Prox_byte         \n"
   "add  $4,%%rdi               \n"
   "add  $3,%%rsi               \n"
   "pop  %%rcx                  \n"
   "loop CODI_Prox_casa         \n"
   "pop  %%dx                   \n"        // Parte que coloca o '=' no final da string 
   "test %%dl,%%dl              \n"        // gerada                                    
   "jz   CODI_Fim               \n"
   "mov  $3,%%rcx               \n"
   "sub  %%dl,%%cl              \n"
   "sub  %%rcx,%%rdi            \n"
   "movb $61,(%%rdi)            \n"
   "dec  %%cl                   \n"
   "inc  %%rdi                  \n"
   "test %%cl,%%cl              \n"
   "jz   CODI_Fim               \n"
   "movb $61,(%%rdi)            \n"
   "inc  %%rdi                  \n"
  "CODI_Fim:                    \n"
   "movb  $0,(%%rdi)             \n"
   :
   :"m"(retorno),"m"(str_normal),"b"(base),"a"(tamanho)
   :"rdi","rsi","rcx","rdx"
  );
 #else
  asm(
   "xorl %%edx,%%edx            \n" 
   "push %%ebx                  \n"
   "movl $3,%%ebx               \n"
   "divl %%ebx                  \n"
   "pop  %%ebx                  \n"
   "movl %%eax,%%ecx            \n"
   "pushw %%dx                  \n"
   "testb %%dl,%%dl             \n"
   "jz   CODI_Pular             \n" 
   "incl %%ecx                  \n"
  "CODI_Pular:                  \n"
   "movl %0,%%edi               \n"
   "movl %1,%%esi               \n"
  "CODI_Prox_casa:              \n"
   "pushl %%ecx                 \n"
   "movl (%%esi),%%eax          \n"
   "rorw $8,%%ax                \n"
   "rorl $16,%%eax              \n"
   "rorw $8,%%ax                \n"
   "shrl $8,%%eax               \n"
   "movw $4,%%cx                \n"
   "shll $2,%%eax               \n"
   "addl $4,%%edi               \n"
  "CODI_Prox_byte:              \n"
   "shrb $2,%%al                \n"
   "xlatb                       \n"
   "decl %%edi                  \n"
   "movb %%al,(%%edi)           \n"
   "shrl $6,%%eax               \n"
   "loop CODI_Prox_byte         \n"
   "addl $4,%%edi               \n"
   "addl $3,%%esi               \n"
   "popl %%ecx                  \n"
   "loop CODI_Prox_casa         \n"
   "popw %%dx                   \n"        // Parte que coloca o '=' no final da string 
   "testb %%dl,%%dl             \n"        // gerada                                    
   "jz   CODI_Fim               \n"
   "movl $3,%%ecx               \n"
   "subb %%dl,%%cl              \n"
   "subl %%ecx,%%edi            \n"
   "movb $61,(%%edi)            \n"
   "decb %%cl                   \n"
   "incl %%edi                  \n"
   "testb %%cl,%%cl             \n"
   "jz   CODI_Fim               \n"
   "movb $61,(%%edi)            \n"
   "incl %%edi                  \n"
  "CODI_Fim:                    \n"
   "movb $0,(%%edi)             \n"
   :
   :"m"(retorno),"m"(str_normal),"b"(base),"a"(tamanho)
   :"edi","esi","ecx","edx"
  );
 #endif
return ;
}




//---------------------------------------
// Funcao para ler a string que contem os
// os campos do header para o DKIM       
// Retornos:                             
// Retorna em op_h os campos encontrados 
// Retorna o numero de campos encontrados
int read_h(char *str_h){
 char *ptr_aux1;
 int cont1=0;
 
 do{
  ptr_aux1=strchr(str_h, ':');
  if(ptr_aux1){
   *ptr_aux1=0;
  }
  snprintf(op_h[cont1++], TAM_hf, "%s", str_h);
  if(ptr_aux1){
   str_h=ptr_aux1+1;
  }
 }while(ptr_aux1);
 return cont1;
}



//---------------------------------------
//          Funcao Principal             
//---------------------------------------
int main(int argc, char *argv[]){
 FILE *arq_email, *arq_chave;
 RSA *priv_key;
 time_t timestamp;
 struct stat dados_entr;
 char dkim_sign[TAM_buffer];
 char fim_header=0;
 char header_dkim[TAM_buffer];
 char sha256_hash[SHA256_DIGEST_LENGTH+1];
 char sha256_hash_base64[50];
 char *ptr_aux1=NULL;
 char *ptr_aux2=NULL;
 char *ptr_aux3=NULL;
 char *ptr_header=NULL;
 char *ptr_header_aux=NULL;
 char *ptr_body=NULL;
 char item_encontrado=0;
 char cmd_sql[TAM_query_conf+120];
 int num_itens=0;
 int cont1=0;
 int cont2=0;
 int resto=0;
 int num_op_h=0;
 int num_campos_h=0;
 int b_lidos=0;
 int tam_body=0;
 int tam_reducao=0;
 unsigned int tam_computar=0;
 unsigned int tam_body_mem=0;
 long rsa_error=0;
 
 
 if(argc < 2){
  printf("Selor DKIM %s\n\n", VERSAO);
  Ajuda:
  printf(" Option      | Description\n");
  printf(" --gen          Specify a mail file to generate a DKIM header (via stdout)\n");
  printf(" -s             To force a selector ('--gen' required)\n");
  printf(" -h             To specify the header fields for DKIM generation ('--gen' required)\n");
  printf("                                     Ex: ./selor_dkim --gen mail.txt -h \"Date:To:From:Subject:Content-Type\"\n");
  printf(" -d             To specify the domain\n");
  printf(" --pkey         To specify the private key\n");
  printf(" --max-body     To set the maximum size of the body to generate a hash (%d -> Default)\n", MAX_body_default);
  printf(" --dbconf       To specify a configuration file for MySQL connection and query for selector\n");
  printf("\n\n");
  printf(" This program returns three values:\n");
  printf("  0 -> The dkim signature was generated successfully\n");
  printf("  1 -> The dkim signature was not generated, because a dkim signature\n        already exists or a selector or public key was not specified \n");
  printf("  2 -> Error\n");
  printf("\n\n");
  return 2;
 }
 
  op_gen[0]=op_s[0]=op_d[0]=op_pkey[0]=op_dbconf[0]=0;
 // -- Lendo parametros --
 for(cont1=1; cont1<argc; cont1++){
  if(!strcmp(argv[cont1], "--gen")){
   cont1++;
   if(argv[cont1])snprintf(op_gen, sizeof(op_gen)-1, "%s", argv[cont1]);
   else goto Ajuda;
  }else if(!strcmp(argv[cont1], "-s")){
   cont1++;
   if(argv[cont1])snprintf(op_s, sizeof(op_s)-1, "%s", argv[cont1]);
   else goto Ajuda;
  }else if(!strcmp(argv[cont1], "-d")){
   cont1++;
   if(argv[cont1])snprintf(op_d, sizeof(op_d)-1, "%s", argv[cont1]);
   else goto Ajuda;
  }else if(!strcmp(argv[cont1], "--pkey")){
   cont1++;
   if(argv[cont1])snprintf(op_pkey, sizeof(op_pkey)-1, "%s", argv[cont1]);
   else goto Ajuda;
  }else if(!strcmp(argv[cont1], "--max-body")){
   cont1++;
   if(argv[cont1])op_max_body=atoi(argv[cont1]);
   else goto Ajuda;
  }else if(!strcmp(argv[cont1], "-h")){
   cont1++;
   if(argv[cont1])num_campos_h=read_h(argv[cont1]);
   else goto Ajuda;
  }else if(!strcmp(argv[cont1], "--dbconf")){
   cont1++;
   if(argv[cont1])snprintf(op_dbconf, sizeof(op_dbconf)-1, "%s", argv[cont1]);
   else goto Ajuda;
  }
 }
 if(!num_campos_h || !op_gen[0] || !op_d[0])goto Ajuda;
 
 
 if(op_dbconf[0]){
  // -- Lendo arquivo de conexao com o banco de dados --
  arq_email=fopen(op_dbconf, "rb");
  if(!arq_email){
   printf("File not found [%s]\n", op_dbconf);
   return 2;
  }
  cpl_dest=linha;
  tamanho=TAM_buffer;
  while(!feof(arq_email)){
   b_lidos=fread(&buffer, 1, TAM_buffer, arq_email);
   if(b_lidos < 0){
    printf("Error reading file %s", op_dbconf);
    fclose(arq_email);
    return 2;
   }
   buffer[b_lidos]=0;
   cpl_orig=buffer;
   while(!cpl(&tamanho, TAM_buffer)){
    cpl_dest=linha;
    if(linha[0] != '#'){
     if(!cmp_str(linha, "Host=", 5)){
      ptr_aux1=&linha[5];
      while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
      snprintf(op_conf_host, sizeof(op_conf_host), "%s", ptr_aux1);
     }else if(!cmp_str(linha, "Port=", 5)){
      ptr_aux1=&linha[5];
      while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
      op_conf_port=atoi(ptr_aux1);
     }else if(!cmp_str(linha, "User=", 5)){
      ptr_aux1=&linha[5];
      while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
      snprintf(op_conf_user, sizeof(op_conf_user), "%s", ptr_aux1);
     }else if(!cmp_str(linha, "Pass=", 5)){
      ptr_aux1=&linha[5];
      while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
      snprintf(op_conf_pass, sizeof(op_conf_pass), "%s", ptr_aux1);
     }else if(!cmp_str(linha, "Db=", 3)){
      ptr_aux1=&linha[3];
      while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
      snprintf(op_conf_db, sizeof(op_conf_db), "%s", ptr_aux1);
     }else if(!cmp_str(linha, "Query=", 6)){
      ptr_aux1=&linha[6];
      while(*ptr_aux1 == ' ' || *ptr_aux1 == 9)ptr_aux1++;
      snprintf(op_conf_query, sizeof(op_conf_query), "%s", ptr_aux1);
     }
    }
   }
  }
  if(!(mysql = mysql_init(NULL))){
   printf("Could not initialize the MySQL functions\n");
   return 2;
  }
  if(!mysql_real_connect(mysql, op_conf_host, op_conf_user, op_conf_pass, op_conf_db, 0, NULL, 0)){
   printf("Could not connect to MySQL server\n");
   return 2;
  }
  snprintf(cmd_sql, TAM_query_conf+120 ,op_conf_query, op_d);
  if(!mysql_query(mysql, cmd_sql)){
   myres=mysql_store_result(mysql);
   if((myreg=mysql_fetch_row(myres))){
    if(myreg[0])strcpy(op_s, myreg[0]);
    if(myreg[1])strcpy(op_pkey, myreg[1]);
   }
   mysql_free_result(myres);
  }else {
   printf("MySQL ERROR [%d] in: %s\n", mysql_errno(mysql) ,cmd_sql);
   return 2;
  }
  mysql_close(mysql);
 }
 
 if(!op_s[0] || !op_pkey[0])return 1;
 
 
 // -- Carregando a chave privada --
 arq_chave=fopen(op_pkey, "rb");
 if(!arq_chave){
  printf("File not found [%s]\n", op_pkey);
  return 2;
 }
 priv_key=RSA_new();
 priv_key=PEM_read_RSAPrivateKey(arq_chave, NULL, NULL, NULL);
 if(!priv_key){
  printf("Erro loading private key\n");
  return 2;
 }
 fclose(arq_chave);
 
 if((stat(op_gen, &dados_entr)) < 0){
  printf("File not found [%s]\n", op_gen);
  return 2;
 }
 //tam_body_mem=dados_entr.st_size;
 //if(tam_body_mem > op_max_body)tam_body_mem=op_max_body;
 tam_computar=dados_entr.st_size;
 if(tam_computar > op_max_body)tam_computar=op_max_body;
 tam_body_mem=tam_computar*2;            // --> Alocando o dobro pois sera convertido de LF para CRLF
 ptr_body=ptr_aux2=malloc(tam_body_mem); // --> Alocando espaco para o corpo do email
 ptr_header=malloc(tam_body_mem);        // --> Alocando espaco para o header do email
 
 ptr_aux3=ptr_aux2+tam_body_mem;       // --> Anotando o final do buffer alocado
 
 sha256_hash_base64[0]=0;
 
 
 
 if (op_gen[0]){
  arq_email=fopen(op_gen, "rb");
  if(!arq_email){
   printf("File not found [%s]\n", op_gen);
   return 2;
  }
  cpl_dest=linha;
  tamanho=TAM_buffer;
  ptr_header_aux=ptr_header;
  while(!feof(arq_email)){
   b_lidos=fread(&buffer, 1, TAM_buffer, arq_email);
   if(b_lidos < 0){
    printf("Error reading file %s", op_gen);
    fclose(arq_email);
    if(ptr_body)free(ptr_body);
    if(ptr_header)free(ptr_header);
    return 2;
   }
   buffer[b_lidos]=0;
   cpl_orig=buffer;
   while(!cpl(&tamanho, TAM_buffer)){
    cpl_dest=linha;
    if(!fim_header){
     // -- Lendo o HEADER --
     if(!linha[0])fim_header=1;
     else {
      if(!cmp_str(linha, "DKIM-Signature:", 15)){
       // -- O email já tem DKIM --
       fclose(arq_email);
       if(ptr_body)free(ptr_body);
       if(ptr_header)free(ptr_header);
       return 1;
      }
      if(item_encontrado && (linha[0] == ' ' || linha[0] == 9)){
       ptr_header_aux+=sprintf(ptr_header_aux, "%s\r\n", linha);
      }else {
       item_encontrado=0;
       for(cont1=0; cont1<num_campos_h; cont1++){
        cont2=strlen(op_h[cont1]);
        if(!cmp_str(linha, op_h[cont1], cont2) && linha[cont2] == ':'){
         op_h_sequence[num_op_h++]=cont1;
         ptr_header_aux+=sprintf(ptr_header_aux, "%s\r\n", linha);
         item_encontrado=1;
         num_itens++;
         break;
        }
       }
      }
     }
    }else {
     // Lendo o CORPO da mensagem --
     if(ptr_body){
      ptr_aux1=linha;
      while(*ptr_aux1 && ptr_aux2 < ptr_aux3)*ptr_aux2++=*ptr_aux1++;
      if(ptr_aux2 < ptr_aux3){
       strcpy(ptr_aux2, "\r\n");
       ptr_aux2+=2;
      }
     }
    }
   }
  }
  fclose(arq_email);
 }
 if(tam_computar == dados_entr.st_size && ptr_aux2 < ptr_aux3){
  ptr_aux2--;
  tam_reducao=-1;
  while(ptr_aux2 > ptr_body && (*ptr_aux2 == 13 || *ptr_aux2 == 10)){
   if(*ptr_aux2 == 10)tam_reducao++;
   ptr_aux2--;                                                                    // -----------------------------
  }                                                                               //                              
  *++ptr_aux2=13;                                                                 // Removendo as linhas em branco
  *++ptr_aux2=10;                                                                 // no final do email            
  *++ptr_aux2=0;                                                                  //                              
 }
 tam_body=ptr_aux2-ptr_body;
 
 
 SHA256((const unsigned char *)ptr_body, tam_body, (unsigned char *)sha256_hash);
 sha256_hash[SHA256_DIGEST_LENGTH]=0;
 base64_cod(sha256_hash_base64, sha256_hash, SHA256_DIGEST_LENGTH);
 if(tam_reducao > 0)truncate(op_gen, dados_entr.st_size-tam_reducao);
 
 // -- Gerando a Assinatura --
 time(&timestamp);
 ptr_aux1=header_dkim;
 ptr_aux1+=sprintf(ptr_aux1, "DKIM-Signature: v=1; a=rsa-sha256; l=%d; c=simple/simple; d=%s;\r\n t=%ld; s=%s;\r\n h=", tam_body, op_d, timestamp, op_s);
 //ptr_aux1+=sprintf(ptr_aux1, "DKIM-Signature: v=1; a=rsa-sha256; c=simple/simple; d=%s;\r\n t=%ld; s=%s;\r\n h=", op_d, timestamp, op_s);
 for(cont1=0; cont1<num_itens; cont1++)ptr_aux1+=sprintf(ptr_aux1, "%s:", op_h[op_h_sequence[cont1]]);
 ptr_aux1[-1]=';';
 strcpy(ptr_aux1, "\r\n");
 ptr_aux1+=2;
 if(sha256_hash_base64[0])cont1+=sprintf(ptr_aux1, " bh=%s;\r\n", sha256_hash_base64);
 ptr_aux1=ptr_header_aux;
 ptr_header_aux+=sprintf(ptr_header_aux, "%s b=", header_dkim);
 SHA256((const unsigned char *)ptr_header, strlen(ptr_header), (unsigned char *)buffer);
 buffer[SHA256_DIGEST_LENGTH]=0;
 if(!RSA_sign(NID_sha256, (const unsigned char *)buffer, SHA256_DIGEST_LENGTH, (unsigned char *)linha, ( unsigned int *)&cont1, priv_key)){
  ERR_load_crypto_strings();
  rsa_error=ERR_get_error();
  printf("RSA_sign error: [%s]\n", ERR_error_string(rsa_error, NULL));
  return 2;
 }
 base64_cod(dkim_sign, linha, cont1);
 cont1=strlen(dkim_sign);
 cont2=cont1 / 68;
 resto=cont1 % 68;
 ptr_aux2=dkim_sign;
 for(cont1=0; cont1<cont2; cont1++){
  strncpy(ptr_header_aux, ptr_aux2, 68);
  ptr_header_aux+=68;
  ptr_aux2+=68;
  if(cont1 < cont2-1 || resto)strcpy(ptr_header_aux, "\r\n   ");
  ptr_header_aux+=5;
 }
 if(resto)strcpy(ptr_header_aux, ptr_aux2);
 printf("%s\r\n", ptr_aux1);      // -- ptr_aux1 --> Contem o header DKIM
 
 if(ptr_body)free(ptr_body);
 if(ptr_header)free(ptr_header);
 return 0;
}



